/* - AdvServoAttachListener - 
 * populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class AdvServoAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServosTxt;
    private JComboBox servoCmb;
    private JComboBox servoTypeCmb;
    private JTextField actVelTxt;
    private JTextField actPosTxt;
    private JTextField currentTxt;
    private JSlider posScrl;
    private JTextField targetPosTxt;
    private JSlider velScrl;
    private JTextField targetVelTxt;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JCheckBox engagedChk;
    private JCheckBox rampingChk;
    private JSlider maxPosScrl;
    private JTextField maxPosTxt;
    private JSlider minPosScrl;
    private JTextField minPosTxt;
    private JCheckBox stoppedChk;
    private Hashtable servoTypes;
    
    /** Creates a new instance of AdvServoAttachListener */
    public AdvServoAttachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numServosTxt, JComboBox servoCmb, JComboBox servoTypeCmb, 
            JTextField actVelTxt, JTextField actPosTxt, JTextField currentTxt, 
            JSlider posScrl, JTextField targetPosTxt, JSlider velScrl, 
            JTextField targetVelTxt, JSlider accelScrl, JTextField accelTxt, 
            JCheckBox engagedChk, JCheckBox rampingChk, JSlider maxPosScrl, 
            JTextField maxPosTxt, JSlider minPosScrl, JTextField minPosTxt, 
            JCheckBox stoppedChk, Hashtable servoTypes)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServosTxt = numServosTxt;
        this.servoCmb = servoCmb;
        this.servoTypeCmb = servoTypeCmb;
        this.actVelTxt = actVelTxt;
        this.actPosTxt = actPosTxt;
        this.currentTxt = currentTxt;
        this.posScrl = posScrl;
        this.targetPosTxt = targetPosTxt;
        this.velScrl = velScrl;
        this.targetVelTxt = targetVelTxt;
        this.accelScrl = accelScrl;
        this.accelTxt = accelTxt;
        this.engagedChk = engagedChk;
        this.rampingChk = rampingChk;
        this.maxPosScrl = maxPosScrl;
        this.maxPosTxt = maxPosTxt;
        this.minPosScrl = minPosScrl;
        this.minPosTxt = minPosTxt;
        this.stoppedChk = stoppedChk;
        this.servoTypes = servoTypes;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            AdvancedServoPhidget attached = (AdvancedServoPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numServosTxt.setText(Integer.toString(attached.getMotorCount()));
            
            for(int i = 0; i < attached.getMotorCount(); i++)
            {
                servoCmb.addItem(new Integer(i));
                attached.setServoType(i, AdvancedServoPhidget.PHIDGET_SERVO_HITEC_HS322HD);
            }
            
            servoCmb.setSelectedIndex(0);
            servoCmb.setEnabled(true);
            
            Enumeration e = servoTypes.keys();
            while(e.hasMoreElements())
            {
                servoTypeCmb.addItem(e.nextElement());
            }
            
            servoTypeCmb.setEnabled(true);
            
            engagedChk.setSelected(attached.getEngaged(0));
            engagedChk.setEnabled(true);
            rampingChk.setSelected(attached.getSpeedRampingOn(0));
            rampingChk.setEnabled(true);
            stoppedChk.setSelected(attached.getStopped(0));
            
            maxPosScrl.setMaximum((int)attached.getPositionMax(0));
            maxPosScrl.setMinimum((int)attached.getPositionMin(0));
            maxPosScrl.setValue((int)attached.getPositionMax(0));
            maxPosTxt.setText(Double.toString(attached.getPositionMax(0)));
            maxPosScrl.setEnabled(true);
            
            minPosScrl.setMaximum((int)attached.getPositionMax(0));
            minPosScrl.setMinimum((int)attached.getPositionMin(0));
            minPosScrl.setValue((int)attached.getPositionMin(0));
            minPosTxt.setText(Double.toString(attached.getPositionMin(0)));
            minPosScrl.setEnabled(true);
            
            posScrl.setMaximum((int)attached.getPositionMax(0) * 128);
            posScrl.setMinimum((int)attached.getPositionMin(0) * 128);
            posScrl.setValue((int)attached.getPositionMin(0) * 128);
            targetPosTxt.setText(Double.toString(attached.getPositionMin(0) * 128));
            posScrl.setEnabled(true);

            //min 0 max 1500
            velScrl.setMaximum((int)attached.getVelocityMax(0));
            velScrl.setMinimum((int)attached.getVelocityMin(0));
            velScrl.setValue((int)attached.getVelocityMin(0));
            targetVelTxt.setText(Double.toString(attached.getVelocityMin(0)));
            velScrl.setEnabled(true);

            //min 0 max 4590
            accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            accelScrl.setMinimum((int)attached.getAccelerationMin(0));
            accelScrl.setValue((int)attached.getAccelerationMin(0));
            accelTxt.setText(Double.toString(attached.getAccelerationMin(0)));
            accelScrl.setEnabled(true);
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
